﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports System.Linq
Imports System.Data.Linq

Public Class EmployeeManagerGrids
    Private db As NorthwindDataContext

    Public Sub New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 请在 InitializeComponent() 调用后添加初始化。
        db = New NorthwindDataContext()
        Dim employeeQuery = From employee In db.Employees _
                            Order By employee.LastName _
                            Select employee
        'ToBindingList 方法可将查询转换成支持 IBindingList 的结构。
        '必须使用 Table<T> 才能转换为绑定列表，以便正确跟踪
        '实体的添加和删除。
        employeeBindingSource.DataSource = employeeQuery
        managerBindingSource.DataSource = employeeQuery.ToList
        employeesBindingSource.DataSource = employeeBindingSource
        employeesBindingSource.DataMember = "Employees"
    End Sub

    Private Sub employeeDataGridView_CellParsing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellParsingEventArgs) Handles employeeDataGridView.CellParsing
        Dim s As String = e.Value

        Dim emp As Employee = (From employee In managerBindingSource.OfType(Of Employee)() _
                                Where employee.ToString() = s _
                                Select employee).FirstOrDefault
        e.Value = emp
        e.ParsingApplied = True
    End Sub

    Private Sub btnSubmitChanges_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSubmitChanges.Click
        Validate()
        db.SubmitChanges()
    End Sub
End Class